KasperskyLab.AddRunner("pc", function (ns, session, settings, locales)
{
	var PasswordControl = function()
	{
		var m_callFunction = function(){};
		var m_balloon = null;


		function OnPing()
		{
			return ns.MaxRequestDelay;
		}

		function OnError(e)
		{
			session.Log("ERR pc - " + (e.message || e));
		}

		session.InitializePlugin(
			function(activatePlugin, registerMethod, callFunction)
			{
				m_callFunction = callFunction;
				activatePlugin("pc", OnPing, OnError);
				registerMethod('pc.disable', function () {
				    if (m_balloon)
				        m_balloon.Disable();
				});
			});

		m_balloon =  new ns.PasswordControlBalloon(settings, locales, m_callFunction, session) ;
	}


	var instance = null;
	ns.RunModule(function()
	{
		try
		{
			if (!instance)
				instance = new PasswordControl;
		}
		catch(e)
		{
			session.Log("PasswordControl exception: " + (e.message || e));
		}
	});
});
